use "/Users/wuqianyan/Desktop/data_springs.dta", clear
***data cleaning 
recode water ( . =1) 
recode facility ( . =1)
recode yes (.=0)
replace substitutes=0 if substitutes==.
gen pastexperience=(trip>1)
drop if distance>800 | primaryreason==0 |income10000==. 
drop if trip>20

*******************************************************TCM***************************************
**************poisson
*1. original P
poisson trip tc100 income10000 substitutes gender water facility blue if distance<800, robust
estimates store p

*2. truncated P
tpoisson trip tc100 income10000 substitutes gender water facility blue if distance<800, robust
estimates store tp

*3. truncated P with endogenous stratification 
gen trip_t=trip-1
poisson trip_t tc100 income10000 substitutes gender water facility blue if distance<800, robust
estimates store tps

***reweight method 
*tpoisson trip tc100 income10000 substitutes gender water facility blue [pweight=1/trip], robust
*estimates store tp_weight 




**********negative bibonimal models

*1.original nb
nbreg  trip tc100 income10000 substitutes gender water facility blue   if distance<800, robust
estimates store nb

*2.truncated nb
tnbreg  trip tc100 income10000 substitutes gender water facility blue  if distance<800,robust
estimates store tnb

*3.nb with endogenous stratification alpha=constant
capture program drop nb2
program  nb2
args lnf xb alpha
tempvar alph lambda
  qui gen double `lambda' = exp(`xb') 
   qui gen double `alph'= exp(`alpha')
  qui replace  `lnf' = lngamma(($ML_y1+1/`alph'))+$ML_y1* ln(`alph')+($ML_y1-1) *ln((exp(`xb')))-($ML_y1+1/`alph')*ln(1+`alph'*(exp(`xb')))-lngamma($ML_y1+1)-lngamma(1/`alph') + ln($ML_y1)
end

ml model lf nb2 (es_count:trip=tc100 income10000 substitutes gender water facility blue) /alpha
ml maximize 
estimates store nb2

*4. nb1 alpha(i)=constant/lambda(i) 
*5. Landry's stata code alpha(i)=alpha*lambda(i)^(p-2)


*6 Martnez-Espieira and Amoako-Tuffour (2007) modeled the unobserved heterogeneity and parameterize the dispersion parameter in terms of demographic characteristics of the visitors.
gnbstrat trip tc100 income10000 substitutes gender water facility blue if distance <800, lnalpha(hadult age gender) 
estimates store gnbstrat

*7 reweight method 
*tnbreg  trip tc100 income10000 substitutes gender water facility blue [pweight=1/trip],robust
*estimates store tnb_weight


esttab  p tp tps nb tnb nb2 gnbstrat using /Users/wuqianyan/Desktop/results_spring.csv, b(2) se(2) aic bic scalars("ll Log lik.") starlevels( * 0.1 ** 0.05 ***  0.01)



***************************************************************** CVM *************************************************

*1.naive logit without correction 
logit yes bid, robust
estimates store logit

*2. naive logit with correction 
gen p1=0.013
gen s1=0.00048*33.24
gen wi=yes*p1/s1+(1-yes)*(1-p1)/(1-s1)
logit yes bid [pweight=wi], vce(robust)
estimates store logit_w
  
*3. logit without correction   
logit yes bid income10000 logdis gender water facility pastexperience , robust
estimates store logitcontrol

*4. logit with correction 
logit yes bid income10000 logdis gender water facility pastexperience  [pweight=wi], vce(robust)
estimates store logitcontrol_w
	
esttab logit logit_w  logitcontrol logitcontrol_w using /Users/wuqianyan/Desktop/logit_cvm.csv, b(3) se(3) aic bic scalars("ll Log lik.") starlevels( * 0.1 ** 0.05 ***  0.01)



